import { MessageFormData } from "@minecraft/server-ui";
import { actionChainModal } from "./formBuilder";
import { parseDynamicText } from "../utils/parsers";
import { DEBUG } from "../config";


export function confirmationForm(player, action, valueMap = {}) {
    if (DEBUG) console.log(`Player: ${player.nameTag}`);
    if (DEBUG) console.log(`Action: ${JSON.stringify(action)}`);
    if (DEBUG) console.log(`Value Map: ${JSON.stringify(valueMap)}`);
    const messageForm = new MessageFormData()
        .title(action?.title ?? "Confirmation")
        .body(parseDynamicText(action?.body, valueMap) ?? "Are you sure?")
        .button1(action?.cancelText ?? "Cancel")
        .button2(action?.confirmText ?? "Confirm");

    messageForm.show(player).then(r => {
        if (r.selection === 1 && action.confirmAction) {
            actionChainModal(action.confirmAction, player, valueMap);
        } else if (action.cancelAction) {
            actionChainModal(action.cancelAction, player, valueMap);
        }
    });
}

